/* - StepperCurrentChangeListener -
 * Display the current data from the current change event
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.event.CurrentChangeListener;
import com.phidgets.event.CurrentChangeEvent;

import javax.swing.JComboBox;
import javax.swing.JTextField;

public class StepperCurrentChangeListener implements CurrentChangeListener{
    
    private JComboBox motorCmb;
    private JTextField currentTxt;
    
    /** Creates a new instance of StepperCurrentChangeListener */
    public StepperCurrentChangeListener(JComboBox motorCmb, JTextField currentTxt)
    {
        this.motorCmb = motorCmb;
        this.currentTxt = currentTxt;
    }

    public void currentChanged(CurrentChangeEvent currentChangeEvent)
    {
        if(currentChangeEvent.getIndex() == ((Integer)motorCmb.getSelectedItem()).intValue())
        {
            currentTxt.setText(Double.toString(currentChangeEvent.getValue()));
        }
    }
    
}
